#!/bin/bash
# Script to run pcraster with NatuurlijkKapitaalModellen and related data.
# The scripts starts a docker file and runs a specific model, after executing the docker instance is removed.
# Basically it runs pcraster in a container, so it's not necessary to locally install pcraster.

# location of the NKM python model code. The following line is for when they are in the directory this script is located.
#export NKM_HOME=`dirname $(readlink -f $0)`/home/johnverberne/nkmodel/NatuurlijkKapitaalModellen
export NKM_HOME=/opt/NatuurlijkKapitaalModellen
export NKM_INI=$NKM_HOME/environment/configuration/ncm.ini
echo 0:$0 1:$1 2:$2 3:$3 4:$4 5:$5 6:$6
echo gdal-python

echo Log the version from git
git -C $NKM_HOME status
git -C $NKM_HOME log -1
echo ==========================CONTENT OF $NKM_HOME
ls -a -l $NKM_HOME
echo ==========================end

echo log python version in docker container
docker run --rm nca-docker python --version

# read the models to run from file
NKM_MODELS=$(</opt/NatuurlijkKapitaalModellen/projects/gbp/models.txt)
for NKM_MODEL in $NKM_MODELS; do
export NKM_MODEL_FULL=$NKM_HOME/source/script/$NKM_MODEL
echo ============================================================
echo RUN MODEL : $NKM_MODEL_FULL $2
echo docker run --rm -v /tmp:/tmp -e NCM_CONFIGURATION=$NKM_INI ncaconda-docker conda run --no-capture-output -n ncm python $NKM_MODEL_FULL $2
echo ============================================================
docker run --rm -v /tmp:/tmp -e NCM_CONFIGURATION=$NKM_INI ncaconda-docker conda run --no-capture-output -n ncm python $NKM_MODEL_FULL $2
done

# create the json form diff results map
echo ---
echo create json from diff results maps $6
echo ---
echo deterime diff
docker run --rm -v /tmp:/tmp ncaconda-docker conda run --no-capture-output -n ncm python /opt/NatuurlijkKapitaalModellen/environment/script/ncm_diff.py $5 $4 $6
echo add raster descriptions
docker run --rm -v /tmp:/tmp ncaconda-docker conda run --no-capture-output -n ncm python /opt/NatuurlijkKapitaalModellen/environment/script/ncm_rasterdescriptions.py $6 /opt//NatuurlijkKapitaalModellen/environment/script/mapdescriptions.ini


